package MT::Plugin::Benchmark;

use strict;
use Benchmark;

use MT;
use vars qw( $VERSION );
$VERSION        = '1.0';

use base qw( MT::Plugin );

###################################### Init Plugin #####################################

my $plugin = new MT::Plugin::Benchmark({
    id                     => 'Benchmark',
    name                   => 'Benchmark',
    author_name            => 'ARK-Web\'s MT Plugin Developers',
    author_link            => 'http://www.ark-web.jp/',
    version                => $VERSION,
    description            => 'This plugin provides benchmark functional tag.',
});

MT->add_plugin($plugin);

sub init_registry {
    my $plugin = shift;

    $plugin->registry({
        tags => {
            function => {
                'Benchmark' => \&hdlr_benchmark,
            }
        }
    });
}

sub instance {
    return $plugin;
}

sub hdlr_benchmark {
    my ($ctx, $args, $cond) = @_;

    my $marker = $args->{marker};
    if ($marker eq "") {
        return "<!-- Benchmark: marker is null -->";
    }
    my $action = $args->{action};
    if ($action eq 'start') {
        return &start_benchmark($ctx, $marker);
    }
    elsif ($action eq 'end') {
        return &end_benchmark($ctx, $marker);
    }
    else {
        return '<!-- Benchmark: invalid action:'. $action .' -->';
    }
}

sub start_benchmark {
    my ($ctx, $marker) = @_;

    my $benchmark = $ctx->stash('benchmark');
    $benchmark->{$marker} = new Benchmark;
    $ctx->stash('benchmark', $benchmark);

    return "";
}

sub end_benchmark {
    my ($ctx, $marker) = @_;

    my $results = '';
    my $benchmark = $ctx->stash('benchmark');
    my $start = $benchmark->{$marker};
    if (!$start) {
        $results = "not started";
    }else{
        my $end = new Benchmark;
        $results = timestr(timediff($end,$start));
    }

    return sprintf("<!-- benchmark %s %s -->", $marker, $results);
}

1;
