package AFormToSlack::Plugin;

use strict;
use utf8;
use AFormToSlack::AFormToSlack;
use LWP::UserAgent;

sub hdlr_template_source_edit_aform {
	my ($cb, $app, $tmpl_ref) = @_;

	my $aform_id = $app->param('id') || '';
	my $aform_to_slack = AFormToSlack::AFormToSlack->load({aform_id => $aform_id});
	if (!$aform_to_slack) {
		$aform_to_slack = AFormToSlack::AFormToSlack->new;
	}
	my $webhooks_url = $aform_to_slack->webhooks_url;
	my $username     = $aform_to_slack->username;
	my $channel      = $aform_to_slack->channel;
	my $body_type    = int($aform_to_slack->body_type);
	my $checked_body_type_0 = $body_type == 0 ? 'checked="checked"' : '';
	my $checked_body_type_1 = $body_type == 1 ? 'checked="checked"' : '';

	my $mtml =<<EOF;
<__trans_section component="AFormToSlack">
<fieldset>
  <h3><__trans phrase="Slack Setting"></h3>
  <div>
    <mtapp:setting
      id="aform_slack_webhooks_url"
      label="<__trans phrase="Incoming WebHooks URL(Token)">"
      hint="<__trans phrase="Incoming WebHooks URL(Token)">" >
      <input type="text" name="aform_slack_webhooks_url" value="$webhooks_url" />
    </mtapp:setting>
    <mtapp:setting
      id="aform_slack_username"
      label="<__trans phrase="User Name(Option)">"
      hint="<__trans phrase="User Name(Option)">" >
      <input type="text" name="aform_slack_username" value="$username" />
      <div class="hint"><__trans phrase="Username at post. Omitted if empty."></div>
    </mtapp:setting>
    <mtapp:setting
      id="aform_slack_channel"
      label="<__trans phrase="Channel(Option)">"
      hint="<__trans phrase="Channel(Option)">" >
      <input type="text" name="aform_slack_channel" value="$channel" />
      <div class="hint"><__trans phrase="Cannel name beginning with '#' or '\@'. If empty, post to channel which is specified on Slack."></div>
    </mtapp:setting>
    <mtapp:setting
      id="aform_slack_body_type"
      label="<__trans phrase="Body type">"
      hint="<__trans phrase="Body type">" >
      <input type="radio" id="aform_slack_body_type_0" name="aform_slack_body_type" value="0" $checked_body_type_0 />
        <label for="aform_slack_body_type_0"><__trans phrase="Fixed body"></label>
      <input type="radio" id="aform_slack_body_type_1" name="aform_slack_body_type" value="1" $checked_body_type_1 />
        <label for="aform_slack_body_type_1"><__trans phrase="Same as body of admin mail"></label>
    </mtapp:setting>
  </div>
</fieldset>
</__trans_section>
EOF
	my $pattern = quotemeta('<mt:include name="include/actions_bar.tmpl" bar_position="bottom" hide_pager="1" settings_bar="1">');
	$$tmpl_ref =~ s/($pattern)/$mtml$1/;
}

sub hdlr_aform_after_save_aform {
	my ($cb, $app, $aform_id) = @_;

	my $webhooks_url = $app->param('aform_slack_webhooks_url') || '';
	my $username     = $app->param('aform_slack_username') || '';
	my $channel      = $app->param('aform_slack_channel') || '';
	my $body_type    = int($app->param('aform_slack_body_type'));

	my $aform_to_slack = AFormToSlack::AFormToSlack->load({aform_id => $aform_id});
	if (!$aform_to_slack) {
		$aform_to_slack = AFormToSlack::AFormToSlack->new;
	}
	$aform_to_slack->set_values({
		aform_id     => $aform_id,
		webhooks_url => $webhooks_url,
		username     => $username,
		channel      => $channel,
		body_type    => $body_type,
	});
	$aform_to_slack->save or die $aform_to_slack->errstr;
}

sub hdlr_aform_after_store {
	my ($cb, $aform_id, $fields, $app, $aform_data) = @_;

	my $aform = MT::AForm->load($aform_id);
	return unless $aform;

	my $aform_to_slack = AFormToSlack::AFormToSlack->load({aform_id => $aform_id});
	return unless $aform_to_slack;
	return unless $aform_to_slack->webhooks_url;

	my $plugin = MT->component('AFormToSlack');

	my %slack_tmpl_param = (
		form_title => $aform->title,
		mt_uri => $app->base . $app->mt_uri(mode => 'manage_aform_data', args => {
			id => $aform->id,
			blog_id => $app->param('blog_id') || '',
        }),
	);

	my $template = 'body_0.tmpl';
	if ($aform_to_slack->body_type eq '1') {
		use File::Basename qw( dirname );
		use AFormEngineCGI::Common;
		use AFormEngineCGI::FormMail;
		require (dirname(__FILE__) . '/../../../AForm/lib/convert_dependence_char.pl');

		my $aform_plugin = MT->component('AForm');
		my %mail_aform_admin_param = (
			datetime => &AFormEngineCGI::Common::get_date(),
			fields => $fields,
			entry_id => $app->param('entry_id') || '',
		);
		my $html = $aform_plugin->load_tmpl(&AFormEngineCGI::FormMail::_get_tmpl_file_path($app, $aform->id, 'mail_aform_admin.tmpl'), \%mail_aform_admin_param);
		my $body = $aform->admin_mail_header;
		$body .= "\n" if ($aform->admin_mail_header !~ m/\n$/);
		$body .= $app->build_page($html, \%mail_aform_admin_param) . $aform->admin_mail_footer;
		$body = &AFormEngineCGI::FormMail::_replace_aform_data_id($body, $aform, $fields);
		$body = &convert_dependence_char($body);

		my $subject = $aform->mail_admin_subject;
		$subject = &convert_dependence_char(&AFormEngineCGI::FormMail::_replace_aform_data_id($subject, $aform, $fields));
		$subject =~ s/\x0D\x0A|\x0D|\x0A//g;

		$slack_tmpl_param{'subject'} = $subject;
		$slack_tmpl_param{'body'} = $body;
		$template = 'body_1.tmpl';
	}
	my $html = $plugin->load_tmpl($template, \%slack_tmpl_param);
	my $text = $app->build_page($html, \%slack_tmpl_param);

	my %param = (
		payload => MT::Util::to_json({
			text     => $text,
			username => $aform_to_slack->username,
			channel  => $aform_to_slack->channel,
		}),
	);
	my $ua = LWP::UserAgent->new;
	$ua->ssl_opts(verify_hostname => 0);
	my $res = $ua->post($aform_to_slack->webhooks_url, \%param);

	MT->log({message => 'AFormToSlack #'. $aform_data->id .': '. $res->decoded_content});
}

1;
