# A plugin for adding "A-Form" functionality.
# Copyright (c) 2008 ARK-Web Co.,Ltd.

package MT::AFormField;

use strict;

use MT::Object;
@MT::AFormField::ISA = qw(MT::Object);
__PACKAGE__->install_properties({
	column_defs => {
		'id' => 'integer not null auto_increment',
		'aform_id' => 'integer not null',
		'type' => 'string(10) not null',
		'label' => 'text',
		'is_necessary' => 'boolean',
		'sort_order' => 'integer',
		'property' => 'text',
	},
	indexes => {
		'id' => 1,
		'aform_id' => 1,
                'type' => 1,
                'sort_order' => 1,
	},
        defaults => {
        },
	audit => 1,
	datasource => 'aform_field',
	primary_key => 'id'
});

sub options {
    my $self = shift;
    my $property = $self->property;

    require JSON;
    my $json_data = JSON::jsonToObj($self->property);
    my $options = $json_data->{options};
    if ( ref($options) eq 'ARRAY' ) {
        for ( my $i=0; $i<@$options; $i++ ) {
            $options->[$i]->{'index'} = $i+1; 
        }
    }
    return $options;
}

sub use_default {
    my $self = shift;
    my $property = $self->property;

    require JSON;
    my $json_data = JSON::jsonToObj($self->property);
    return $json_data->{use_default};
}

sub default_label {
    my $self = shift;
    my $property = $self->property;

    require JSON;
    my $json_data = JSON::jsonToObj($self->property);
    return $json_data->{default_label};
}

sub privacy_link {
    my $self = shift;
    my $property = $self->property;

    require JSON;
    my $json_data = JSON::jsonToObj($self->property);
    return $json_data->{privacy_link};
}

sub is_replyed {
    my $self = shift;
    my $property = $self->property;

    require JSON;
    my $json_data = JSON::jsonToObj($self->property);
    return $json_data->{is_replyed};
}
1;
