# A plugin for adding "A-Form" functionality.
# Copyright (c) 2008 ARK-Web Co.,Ltd.

package AFormEngineCGI::Common;

sub get_date {
    ( $sec, $min, $hour, $mday, $mon, $year ) = localtime( time );
    $year += 1900;
    $mon += 1;
    return sprintf("%d/%02d/%02d %02d:%02d:%02d", $year,$mon,$mday, $hour,$min,$sec);
}

sub must_check {
    my( $str ) = @_;
	# 全角スペースだけで構築された値は必須チェックでは
	# 許可させないため、まずは全角スペースを半角に変換する
    &z2h_space( \$str );
    return 0 if(not (defined($str) and not $str =~ /^\s*$/));
    return 1;
}

sub num_check {
    my( $str ) = @_;
    return 0 if(not (defined($str) and not $str =~ /^\s*$/));
    return( ( $str !~ m/[^\d-]/ ) );
}

sub int_check {
    my( $str ) = @_;
    return 0 if(not (defined($str) and not $str =~ /^\s*$/));
    return( ( $str !~ m/[^\d]/ ) );
}

sub mail_check {
    my( $str ) = @_;

    return ( $str =~ m/^([*+!.&#$|\'\\%\/0-9a-z^_`{}=?~:-]+)@(([0-9a-z-]+\.)+[0-9a-z]{2,})$/i );
}

sub url_check {
    my ( $url ) = @_;

    # http:// or https://
    if ( !( $url =~ m#^https?://[^/].*#i ) ) {
        return 0;
    }
    return 1;
}

sub zipcode_check {
    my ( $zipcode ) = @_;

    if ( !( $zipcode =~ m#^\d{3}\-\d{4}$# ) ){
        return 0;
    }
    return 1;
}

sub z2h_space {
    my( $r_str ) = @_;
    $$r_str =~ s/\xA1\xA1/\x20/g;
}

sub h2z_space {
    my( $r_str ) = @_;
    $$r_str =~ s/\x20/\xA1\xA1/g;
}


1;
