<?php
require_once('lib/JSON.php');
require_once('classes/aform.class.php');
require_once('classes/aform_field.class.php');


function smarty_modifier_aform( $entry_text ) {
    $entry_text = _replace_form($entry_text, '<\!--', '-->');
    $entry_text = _replace_form($entry_text, '\[\[', '\]\]');

    return $entry_text;
}


function _replace_form( $entry_text, $pattern_pre, $pattern_post ) {

    preg_match_all("/${pattern_pre}aform(\d+)${pattern_post}/", $entry_text, $matches);
    foreach ( $matches[1] as $match_no ){
        $aform_id = (int)$match_no;

        # get aform
        $aform_access = new AFormAccess();
        $aform = $aform_access->load($aform_id);
        if( !$aform ){
            $entry_text = preg_replace("/${pattern_pre}aform${match_no}${pattern_post}/i", "", $entry_text);
            continue;
        }

        $buf = '';
        if( $aform->status == 2 ){	# published
            # generate form
            $buf = _generate_form_view($aform);
        }

        # replace
        $entry_text = preg_replace("/${pattern_pre}aform${match_no}${pattern_post}/i", $buf, $entry_text);
    }
    return $entry_text;
}


function _generate_form_view( $aform ) {

    global $mt;
    $ctx =& $mt->context();

    # get plugin path
    $plugin_paths = $mt->config('PluginPath');
    if( count($plugin_paths) == 0 ){
        return '';
    }

    # get script url dir
    $script_url_dir = _get_script_url_dir();

    # set vars
    $vars =& $ctx->__stash['vars'];
    $vars['blog_id'] = $ctx->stash('blog_id');
    $vars['id'] = $aform->id;
    $vars['title'] = $aform->title;
    $vars['fields'] = _get_fields($aform->id);
    $vars['action_url'] = $script_url_dir . 'aform_engine.cgi';
    $vars['logger_url'] = $script_url_dir . 'aform_logger.cgi';
    $vars['checker_url'] = $script_url_dir . 'aform_checker.cgi';
    $vars['aform_url'] = $ctx->tag('EntryPermalink');
    $vars['charset'] = $mt->config('publishcharset');
    $vars['preview'] = 0;

    $tmp_caching = $ctx->caching;
    $ctx->caching = false;
    $html = $ctx->fetch($plugin_paths[0] . '/AForm/tmpl/aform_form.tmpl');
    $ctx->caching = $tmp_caching;
    return $html;
}


function _get_fields( $aform_id ) {

    $aform_field_access = new AFormFieldAccess();
    $ary_aform_fields = $aform_field_access->load(
      array('aform_id' => $aform_id),
      array('sort' => 'sort_order')
    );

    $fields = array();
    foreach( $ary_aform_fields as $aform_field ){
        $param = array(
          id => $aform_field->id,
          type => $aform_field->type,
          label => $aform_field->label,
          is_necessary =>  $aform_field->is_necessary,
          options => $aform_field->options,
          use_default => $aform_field->use_default,
          default_label => $aform_field->default_label,
          privacy_link => $aform_field->privacy_link,
          is_replyed => $aform_field->is_replyed,
        );
        array_push($fields, $param);
    }
    return $fields;
}


function _get_script_url_dir() {

    global $mt;
    $plugin_config = $mt->db->fetch_plugin_config('A-Form');
    $script_url_dir = $plugin_config['script_url_dir'];
    if( preg_match("#\/$#", $script_url_dir) ){
        $script_url_dir .= '/';
    }
    if( ! _url_check($script_url_dir) ){
        $script_url_dir = $mt->config('cgipath') . 'plugins/AForm/';
    }
    return $script_url_dir;
}


function _url_check( $url ) {
    # http:// or https://
    return preg_match("#^https?://[^/].*#i", $url);
}

?>
