# A plugin for adding "A-Form" functionality.
# Copyright (c) 2008 ARK-Web Co.,Ltd.

package AFormEngineCGI::FormMail;

use strict;
use Time::Local;
use AFormEngineCGI::Common;
use MT::Mail;


sub validate_param {
    my $app = shift;
    my $aform = shift;

    my @error_msgs;

    my $fields = &_inject_param_value($app, &_get_fields($app, $aform), '');

    foreach my $field ( @$fields ){
        # Necessary
        if( $field->{'is_necessary'} ) {
            if( !&AFormEngineCGI::Common::must_check( $field->{'label_value'} ) ) {
              if( $field->{'type'} eq 'privacy' ){
                push(@error_msgs, $field->{'label'} . 'に同意してください。規約にご同意いただける場合チェックを入れてください（ご同意いただけない場合は送信できません）');
              }else{
                push(@error_msgs, $field->{'label'} . 'が入力されていません');
              }
            }
        }

        # If any value not received, Go next!
        next if( !&AFormEngineCGI::Common::must_check( $field->{'label_value'} ) );

        # E-Mail
        if ( $field->{'type'} eq 'email' ) {
            if( !&AFormEngineCGI::Common::mail_check( $field->{'label_value'} ) ) {
                push(@error_msgs, 'メールアドレスのフォーマット不正。例）foo@example.com （英数記号のみ）');
            }
        }
        # Tel
        if ( $field->{'type'} eq 'tel' ) {
            if( !&AFormEngineCGI::Common::num_check( $field->{'label_value'} ) ) {
                push(@error_msgs, '電話番号のフォーマット不正。例）03-1234-5678　（数字とハイフンのみ）');
            }
        }
        # URL
        if ( $field->{'type'} eq 'url' ) {
            if( !&AFormEngineCGI::Common::url_check( $field->{'label_value'} ) ) {
                push(@error_msgs, 'URLのフォーマット不正。例) http://www.example.com/ （英数記号のみ）');
            }
        }
        # Zipcode
        if ( $field->{'type'} eq 'zipcode' ) {
            if( !&AFormEngineCGI::Common::zipcode_check( $field->{'label_value'} ) ) {
                push(@error_msgs, '郵便番号のフォーマット不正。例）123-4567 （数字とハイフンのみ）');
            }
        }
    }

    return @error_msgs;
}

sub generate_form_preview {
    my $app = shift;
    my $aform = shift;

    my %param = (
        id => $aform->id,
        title => $aform->title,
        fields => &_get_fields($app, $aform),
        action_url => &_get_action_url($app),
        logger_url => &_get_logger_url($app),
        charset => $app->charset,
        preview => 1,
    );

    my $html = $app->load_tmpl('aform_form.tmpl', \%param);
    return $app->build_page($html, \%param);
}

sub generate_form_view {
    my $app = shift;
    my $aform = shift;
    my $ctx = shift;

    my %param = (
        blog_id => $ctx->stash('blog_id'),
        id => $aform->id,
        title => $aform->title,
        fields => &_get_fields($app, $aform),
        action_url => &_get_action_url($app),
        logger_url => &_get_logger_url($app),
        checker_url => &_get_checker_url($app),
        aform_url => $ctx->stash('entry')->permalink,
        charset => $app->charset,
        preview => 0,
    );

    my $html = $app->load_tmpl('aform_form.tmpl', \%param);
    return $app->build_page($html, \%param);
}

sub generate_confirmation_view {
    my $app = shift;
    my $aform = shift;

    my $blog_id = int($app->param('blog_id'));

    my %param = (
        id => $aform->id,
        title => $app->blog->name,
        aform_title => $aform->title,
        fields => &_inject_param_value($app, &_get_fields($app, $aform), 'html'),
        blog_id => $blog_id,
        use_xhr => ($aform->thanks_url eq '') ? 1 : 0,
        blog_top => $app->blog->site_url,
        action_url => &_get_action_url($app),
        logger_url => &_get_logger_url($app),
        aform_url => $app->param('aform_url'),
        app_version_id => $app->version_id,
        template_set => $app->blog->template_set,
    );

    my $tmpl = $app->load_tmpl('aform_confirm.tmpl', \%param);
    $tmpl->context->stash('blog_id', $blog_id);
    return $app->build_page($tmpl, \%param);
}

sub generate_finish_view {
    my $app = shift;

    my $blog_id = int($app->param('blog_id'));

    my %param = (
        title => $app->blog->name,
        blog_id => $blog_id,
        blog_top => $app->blog->site_url,
        app_version_id => $app->version_id,
        template_set => $app->blog->template_set,
    );

    my $tmpl = $app->load_tmpl('aform_finish.tmpl', \%param);
    $tmpl->context->stash('blog_id', $blog_id);
    return $app->build_page($tmpl, \%param);
}

sub generate_error_view {
    my $app = shift;
    my $error_msgs = shift;

    my $blog_id = int($app->param('blog_id'));

    my %param = (
        title => $app->blog->name,
        blog_id => $blog_id,
        error_msgs => $error_msgs,
        app_version_id => $app->version_id,
        template_set => $app->blog->template_set,
    );

    my $tmpl = $app->load_tmpl('aform_error.tmpl', \%param);
    $tmpl->context->stash('blog_id', $blog_id);
    return $app->build_page($tmpl, \%param);
}

sub _get_fields {
    my $app = shift;
    my $aform = shift;

    my @aform_fields = MT::AFormField->load({ aform_id => $aform->id() }, { sort => 'sort_order' });

    my @fields;
    for my $aform_field (@aform_fields) {
        my $param = {
            id => $aform_field->id,
            type => $aform_field->type,
            label => $aform_field->label,
            is_necessary =>  $aform_field->is_necessary,
            options => $aform_field->options,
            use_default => $aform_field->use_default,
            default_label => $aform_field->default_label,
            privacy_link => $aform_field->privacy_link,
            is_replyed => $aform_field->is_replyed,
        };
        push(@fields, $param);
    }
    return \@fields;
}


sub _get_script_url_dir {
    my $app = shift;

    my $plugin = MT->component('AForm');
    my $script_url_dir = $plugin->get_config_value('script_url_dir');
    if( $script_url_dir !~ m#\/$# ){
        $script_url_dir .= '/';
    }
    if( ! &AFormEngineCGI::Common::url_check( $script_url_dir ) ){
        $script_url_dir = $app->mt_path . 'plugins/AForm/';
    }
    return $script_url_dir;
}


sub _get_action_url {
    my $app = shift;

    return &_get_script_url_dir($app) . 'aform_engine.cgi';
}

sub _get_logger_url {
    my $app = shift;

    return &_get_script_url_dir($app) . 'aform_logger.cgi';
}

sub _get_checker_url {
    my $app = shift;

    return &_get_script_url_dir($app) . 'aform_checker.cgi';
}

sub _inject_param_value {
    my $app = shift;
    my $fields = shift;
    my $mode = shift;

    for my $field (@$fields) {
        if (  $field->{'type'} eq 'checkbox' || $field->{'type'} eq 'privacy' ) {
            my $options = $field->{'options'};
            if ( ref($options) eq 'ARRAY' ) {
                my @values;
                my %hash_values;
                for ( my $i=0; $i<@$options; $i++ ) {
                    my $value = $app->param(&_get_field_key($field->{'id'}, $i+1));
                    if( $value ne '' && $value =~ /\d+/ ){
                      push(@values, $value);
                      $hash_values{$i+1} = $value;
                   }
                }
                $field->{'values'} = \@values;
                $field->{'hash_values'} = \%hash_values;
                $field->{'label_value'} = join(' ', map { $field->{'options'}->[$_-1]->{'label'} } @values);
            } else {
                return $app->error(
                $app->translate( "Checkbox field always require array data structure. Illegal data structure is found." ) );
            }
        } else {
            my $value = $app->param(&_get_field_key($field->{'id'}));
            if ( $field->{'type'} eq 'radio' || $field->{'type'} eq 'select' || $field->{'type'} eq 'prefecture' ) {
                if( $value ne '' && $value =~ /\d+/ ){
                    $field->{'value'} = $value;
                    my $options = $field->{'options'};
                    if ( ref($options) eq 'ARRAY' ) {
                        foreach my $option (@$options) {
                            if( $option->{'value'} eq $value ){
                                $field->{'label_value'} = $option->{'label'};
                                last;
                            }
                        }
                    } else {
                        return $app->error(
                        $app->translate( "Radio or Select field always require array data structure. Illegal data structure is found." ) );
                    }
                }
            } else {
                $field->{'value'} = $value;
                $field->{'label_value'} = $value;
            }
        }
        if( $mode eq 'html' ){
            $field->{'value'} = MT::Util::encode_html($field->{'value'});
            $field->{'label_value'} = MT::Util::encode_html($field->{'label_value'});
            $field->{'label_value'} = &_crlf2br($field->{'label_value'});
        }
    }

    return $fields;
}

sub _get_field_key {
    my $id = shift;
    my $index = shift;
    return $index ne '' ? 'aform-field-' . $id . '-' . $index : 'aform-field-' . $id;
}

sub _crlf2br {
    my $str = shift;
    $str =~ s/\x0D\x0A/<br\/>/g;
    $str =~ s/\x0D/<br\/>/g;
    $str =~ s/\x0A/<br\/>/g;
    return $str;
}

sub _get_csv_record {
	my ($fields) = @_;
        my $datetime = &AFormEngineCGI::Common::get_date(); 

	my $spliter = ",";
	my $data = qq("$datetime");
	foreach my $field ( @$fields ){
            if( $field->{'type'} ne 'label' ){
		$field->{'label_value'} =~ s/"/""/g;
		$data .= qq($spliter"$field->{'label_value'}");
            }
	}

	return $data;
}

sub check_double_submit
{
	my $app = shift;
	my $aform = shift;

	my ($data, $cmp_date, $compare, $double_submit_flag);

	my $fields = &_inject_param_value($app, &_get_fields($app, $aform), '');
	$data = &_get_csv_record($fields);
	$data =~ s/.*?\",(.*)/$1/; # remove first column

	# get last post data
	my $last_data = MT::AFormData->load( 
		{ aform_id => $aform->id }, 
		{ sort_order => 'created_on', direction => 'descend', limit => 1 } );
	if( !$last_data ){
		return 0;
	}

	$compare = $last_data->values;
	$compare =~ /\"(.*?)\",(.*)/; # divine datetime and datas
	$cmp_date = $1;
	$compare  = $2;

	my $DOUBLE_SUBMIT_TIME_RANGE = 30;	# sec
	if ($data eq $compare
	and _datetime2timelocal($cmp_date)+$DOUBLE_SUBMIT_TIME_RANGE - time() > 0) {
		return 1;
	}

	return 0;
}

sub _datetime2timelocal {
	my ($date) = @_;
	
	$date =~ /^(\d+)\/(\d+)\/(\d+) (\d+):(\d+):(\d+)$/;
	my ($year) = $1;
	my ($mon)  = $2;
	my ($day)  = $3;
	my ($hour) = $4;
	my ($min)  = $5;
	my ($sec)  = $6;
	
	return timelocal($sec, $min, $hour, $day, $mon-1, $year);
}

sub _get_customer_mail {
	my( $fields ) = @_;

        my @customer_mails;
	foreach my $field ( @$fields ){
		if( $field->{'type'} == 'email' && $field->{'is_replyed'} && &AFormEngineCGI::Common::mail_check($field->{'value'}) ){
			push( @customer_mails, $field->{'value'} );
		}
	}
	return( \@customer_mails );
}

sub send_mail {
	my $app = shift;
	my $aform = shift;

	my $fields = &_inject_param_value($app, &_get_fields($app, $aform), '');
	my $customer_mails = &_get_customer_mail($fields);

	my %param = (
		datetime => &AFormEngineCGI::Common::get_date(),
		fields => $fields,
	);
	my $html = $app->load_tmpl('mail_aform_admin.tmpl', \%param);
	my $body = $aform->mail_header;
        $body .= "\n" if ($aform->mail_header !~ m/\n$/);
	$body .= $app->build_page($html, \%param) . $aform->mail_footer;

        my $mail_from = $aform->mail_to;
	my %headers = ( 
		'From' => $mail_from,
		'To' => $aform->mail_to,
		'Subject' => $aform->mail_subject,
		'Bcc' => '',
		'Return-Path' => $mail_from,
		'Reply-To' => ( @$customer_mails ) ? join(',', @$customer_mails) : $mail_from,
	);
	MT::Mail->send(\%headers, $body);
}


sub reply_to_customer {
	my $app = shift;
	my $aform = shift;

	my $fields = &_inject_param_value($app, &_get_fields($app, $aform), '');
	my $customer_mails = &_get_customer_mail($fields);

	if( @$customer_mails == 0 ) {
		return;
	}

	my %param = (
		datetime => &AFormEngineCGI::Common::get_date(),
		fields => $fields,
	);
	my $html = $app->load_tmpl('mail_aform_customer.tmpl', \%param);
	my $body = $aform->mail_header;
        $body .= "\n" if ($aform->mail_header !~ m/\n$/);
        $body .= $app->build_page($html, \%param) . $aform->mail_footer;

        my $mail_from = $aform->mail_to;
        foreach my $customer_mail ( @$customer_mails ){
	  my %headers = ( 
		'From' => $mail_from,
		'To' => $customer_mail,
		'Subject' => $aform->mail_subject,
		'Bcc' => '',
		'Return-Path' => $mail_from,
		'Reply-To' => $mail_from,
	  );
	  MT::Mail->send(\%headers, $body);
        }
}


sub store {
    my $app = shift;
    my $aform = shift;

    my $fields = &_inject_param_value($app, &_get_fields($app, $aform), '');
    my $csv_record = &_get_csv_record($fields);

    my $aform_data = new MT::AFormData;
    $aform_data->set_values(
        {
            aform_id => int($app->param('id')),
            values => $csv_record,
            aform_url => $app->param('aform_url'),
        }
    );
    $aform_data->save();


    # get config values
    my $alert_mail = MT->component('AForm')->get_config_value('alert_mail');
    if( &AFormEngineCGI::Common::mail_check( $alert_mail ) ){
        # data was really saved ?
        if( ! $aform_data->count( { values => $csv_record } ) ){
            &_sendmail_save_data_failed($app, $aform, $fields, $alert_mail);
        }
    }
}


sub _sendmail_save_data_failed {
    my $app = shift;
    my $aform = shift;
    my $fields = shift;
    my $alert_mail = shift;

    my %param = (
        aform_id => sprintf("%03d", $aform->id),
        datetime => &AFormEngineCGI::Common::get_date(),
        fields => $fields,
        aform_url => $app->param('aform_url'),
    );
    my $tmpl = $app->load_tmpl('mail_save_data_failed.tmpl', \%param);
    my $mail_body = $app->build_page($tmpl, \%param);

    my %headers = (
        'From'    => $alert_mail,
        'To'      => $alert_mail,
        'Subject' => '【重要】A-Form 保存処理が失敗した可能性があります ' . &AFormEngineCGI::Common::get_date(),
        'Return-Path' => $alert_mail,
        'Reply-To' => $alert_mail,
    );
    MT::Mail->send(\%headers, $mail_body);
}


sub sendmail_unpublished_form_access {
    my $app = shift;
    my $aform = shift;

    # get config values
    my $alert_mail = MT->component('AForm')->get_config_value('alert_mail');
    if( ! &AFormEngineCGI::Common::mail_check( $alert_mail ) ){
        return;
    }

    my @fields;
    my %params = $app->param_hash;
    foreach my $param_key ( sort keys %params ){
        if( $param_key !~ m/^aform-field-(\d+)/ ){
            next;
        }
        my $aform_field = $app->model('aform_field')->load($1);
        my $field = {
            label => $aform_field ? $aform_field->label : $param_key,
            label_value => $app->param($param_key),
        };
        push(@fields, $field);
    }

    my %param = (
        aform_id => sprintf("%03d", int($app->param('id'))),
        datetime => &AFormEngineCGI::Common::get_date(),
        fields => \@fields,
    );
    my $tmpl = $app->load_tmpl('mail_unpublished_form_access.tmpl', \%param);
    my $mail_body = $app->build_page($tmpl, \%param);

    my %headers = (
        'From'    => $alert_mail,
        'To'      => $alert_mail,
        'Subject' => '[A-Form Warning] Unpublished form was accessed.',
        'Return-Path' => $alert_mail,
        'Reply-To' => $alert_mail,
    );
    MT::Mail->send(\%headers, $mail_body);
}

1;
