<?php
class AFormField  {

    var $id = null;
    var $type = null;
    var $label = null;
    var $is_necessary = null;
    var $options = null;
    var $use_default = null;
    var $default_label = null;
    var $privacy_link = null;
    var $is_replyed = null;

    function AFormField(){
    }

    function set( $data ){
        $this->id = $data['aform_field_id'];
        $this->type = $data['aform_field_type'];
        $this->label = $data['aform_field_label'];
        $this->is_necessary = $data['aform_field_is_necessary'];
        $this->set_properties( $data['aform_field_property'] );
    }

    function set_properties( $property ){
        $json = new Services_JSON(SERVICES_JSON_LOOSE_TYPE);
        $json_data = $json->decode($property);

        $this->use_default = $json_data['use_default'];
        $this->default_label = $json_data['default_label'];
        $this->privacy_link = $json_data['privacy_link'];
        $this->is_replyed = $json_data['is_replyed'];
        $this->options = $json_data['options'];
        if( is_array($this->options) ){
            for( $i=0; $i < count($this->options); $i++ ){
                $this->options[$i]{"index"} = $i+1;
            }
        }
    }
}

class AFormFieldAccess {

    function AFormFieldAccess() {
    }

    function load( $terms = null, $args = null ){

        global $mt;
        $ary_results = $mt->db->load('aform_field', $terms, $args);

        if( count($ary_results) > 0 ){
            $ary_aform_fields = array();
            foreach( $ary_results as $result ){
                $aform_field = new AFormField();
                $aform_field->set($result);
                $ary_aform_fields[] = $aform_field;
            }
            return $ary_aform_fields;
        }else{
            return null;
        }
    }
}
?>
