<?php

global $mt;

if( !$mt ){
    # require元で下記をglobalに宣言していることを想定
    global $mt_root_dir, $blog_id;
    $phpdir      = $mt_root_dir . DIRECTORY_SEPARATOR . "php";
    $mtphp_path  = $mt_root_dir . DIRECTORY_SEPARATOR . "php" . DIRECTORY_SEPARATOR . "mt.php";
    $config_path = $mt_root_dir . DIRECTORY_SEPARATOR . "mt-config.cgi";

    set_include_path(
        $phpdir . PATH_SEPARATOR .
        $phpdir . DIRECTORY_SEPARATOR . "lib" . PATH_SEPARATOR .
        $phpdir . DIRECTORY_SEPARATOR . "extlib" . PATH_SEPARATOR .
        $phpdir . DIRECTORY_SEPARATOR . "extlib" . DIRECTORY_SEPARATOR . "smarty" . DIRECTORY_SEPARATOR . "libs" . PATH_SEPARATOR .
        $phpdir . DIRECTORY_SEPARATOR . "extlib" . DIRECTORY_SEPARATOR . "adodb5" . PATH_SEPARATOR .
        $phpdir . DIRECTORY_SEPARATOR . "extlib" . DIRECTORY_SEPARATOR . "FirePHPCore" . PATH_SEPARATOR .
        get_include_path()
        );
    
    $mt_code_with_pdp_init = get_mt_code_with_pdp_init($mtphp_path);
    eval('?>' . $mt_code_with_pdp_init);

    $mt = MT::get_instance($blog_id, $config_path);
    $mt->pdp_init($blog_id);
 }

function get_mt_code_with_pdp_init($mtphp_path) {

    $mtphp_code = file_get_contents($mtphp_path);

    $replaces = array(array('old' => 'function view(',
                            'new' => 'function pdp_init('),
                      array('old' => '$output = $ctx->fetch(\'mt:\'.$tpl_id, $cache_id);',
                            'new' => 'if( !empty($ctx->compile_dir) && !is_dir($ctx->compile_dir) ){' .
                                     '    mkdir($ctx->compile_dir);' .
                                     '}' .
                                     'return;'),
                      array('old' => '$output = $this->fetch(\'mt:\'.$tpl_id, $cache_id);',
                            'new' => 'if( !empty($ctx->compile_dir) && !is_dir($ctx->compile_dir) ){' .
                                     '    mkdir($ctx->compile_dir);' .
                                     '}' .
                                     'return;'),
                      array('old' => '$data = $this->resolve_url($path);',
                            'new' => '$data = $this->resolve_url($path, 1);'),
                      array('old' => '$this->http_error = 404;',
                            'new' => ''),
                      array('old' => 'header("HTTP/1.1 404 Not found");',
                            'new' => ''),
                      array('old' => 'return $ctx->error($this->translate("Page not found - [_1]", $path), E_USER_ERROR);',
                            'new' => ''),
                      array('old' => '$fi_path = $data->fileinfo_url;',
                            'new' => 'if( $data ){$fi_path = $data->fileinfo_url;'),
                      array('old' => '$this->configure_paths($blog->site_path());',
                            'new' => '$this->configure_paths($blog->site_path());}'));
    preg_match('/(function view\(.*?) function /s', $mtphp_code, $matchs);
    $pdp_init_code = $matchs[1];

    foreach ($replaces as $replace) {
        $pdp_init_code = replace_code($replace['old'], 
                                      $replace['new'],
                                      $pdp_init_code);
    }
    $mtphp_code = str_replace('function view(', $pdp_init_code . 'function view(', $mtphp_code);
    $mtphp_code = preg_replace('/__FILE__/', "'" . $mtphp_path . "'", $mtphp_code);

    return $mtphp_code;
}

function replace_code($old_code, $new_code, $code) {
    $old_code = strtr($old_code, array('$' => '\$'));
    $old_code = strtr($old_code, array('(' => '\('));
    $old_code = strtr($old_code, array(')' => '\)'));
    $old_code = strtr($old_code, array('[' => '\['));
    $old_code = strtr($old_code, array(']' => '\]'));
    $old_code = strtr($old_code, array('/' => '\/'));
    $old_code = strtr($old_code, array('.' => '\.'));

    $code = preg_replace('/' . $old_code . '/', $new_code, $code);

    return $code;
}

function pdp_display($contents){

    global $mt;

    $pluginData = $mt->db()->fetch_plugin_config("PartialDynamicPublishing");
    if ($pluginData["temp_dir"] == "sys_get_temp_dir") {
      $tempfile = tempnam(sys_get_temp_dir(), 'pdp');
    } else {
      $tempfile = tempnam('/tmp', 'pdp');
    }
    file_put_contents($tempfile, $contents);

    $ctx =& $mt->context();
    pdp_clear_compiled_tpl($ctx, 60*60);
    $ctx->display("file:" . $tempfile);
    unlink($tempfile);
}

function pdp_clear_compiled_tpl($ctx, $ext_time) {
    if (is_callable(array($ctx, 'clearCompiledTemplate'))) {
        $ctx->clearCompiledTemplate(null, null, $ext_time);
        return true;
    }
    if (is_callable(array($ctx, 'clear_compiled_tpl'))) {
        $ctx->clear_compiled_tpl(null, null, $ext_time);
        return true;
    }

    var_dump("clearCompiledTemplate not exists");
    return false;
}
