# Copyright (c) 2008 ARK-Web Co.,Ltd.

package MT::Plugin::PartialDynamicPublishing;

use strict;
use MT;
use MT::App;
use File::Basename;

use vars qw( $VERSION );
$VERSION = '1.1.5';

use base qw( MT::Plugin );

###################################### Init Plugin #####################################

my $plugin = new MT::Plugin::PartialDynamicPublishing({
    id => 'PartialDynamicPublishing',
    name => 'PartialDynamicPublishing',
    author_name => '<MT_TRANS phrase="_PLUGIN_AUTHOR">',
    author_link => 'http://www.ark-web.jp/',
    version => $VERSION,
    description => '<MT_TRANS phrase="_PLUGIN_DESCRIPTION">',
    doc_link => 'http://www.ark-web.jp/movabletype/',
    l10n_class => 'PartialDynamicPublishing::L10N',
    system_config_template => 'system_config.tmpl',
    settings => new MT::PluginSettings([
        [ 'temp_dir' => { Default => 'tmp', Scope => 'system' }],
    ]),
});
MT->add_plugin($plugin);

sub init_registry {
    my $plugin = shift;
    $plugin->registry({
        tags => {
            block => {
                'PartialDynamicPublishing' => \&hdlr_partial_dynamic_publishing,
            },
        },
    });
}

sub instance {$plugin}

sub hdlr_partial_dynamic_publishing {
    my ($ctx, $args, $cond) = @_;

    my $ignore_extension = $args->{'ignore_extension'} || 0;
    my $is_preview = $ctx->stash('vars')->{'preview_template'};
    my $action_url = $ctx->stash('vars')->{'script_url'} || '';
    if( $is_preview || (!$ignore_extension && $action_url =~ m/\.cgi/i) ){
        my $builder = $ctx->stash('builder');
        my $tokens = $ctx->stash('tokens');
        defined (my $str = $builder->build($ctx, $tokens) )
            or return $ctx->error($builder->errstr);
        return $str;
    }

    my $uncompiled = $ctx->stash('uncompiled');
    my $app = MT::App->new;
    my $cgi_path = MT->instance->server_path() || "";
    $cgi_path =~ s!/*$!!;
    my $pdp_path    = File::Spec->canonpath(dirname(__FILE__) . "/php/partial_dynamic_publishing.php");
    my $blog_id     = $ctx->stash('blog_id');

    my $out = "<?php ob_start() ?>$uncompiled<?php
\$contents = ob_get_contents();
ob_end_clean();

\$mt_root_dir = '$cgi_path';
\$blog_id     = $blog_id;
require_once('$pdp_path');
pdp_display(\$contents);
?>";
    return $out;
}

1;
