<?php
/*
 * $Id$
 * 
 * License:  GNU General Public License
 *
 * Copyright (c) 2006 in3c.org
 *
 * This software is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 * USA.
 * 
 */

include_once LIB_DIR . "TagCloud.class.php";

// ɽ
define("TAGCLOUD_MAX","20");

/**
 * 
 * 
 *     #tagcloud(ѥ,ɽ)
 * 
 *  
 *     ֥åץ饰
 *
 * 
 *      ꤷѥǻϤޤƥڡФơ󥯤Ƥ򥫥Ȥ
 *      Υڡtagcloudɽޤ
 *      tagcloudɽˤϡastronoteTagCloud饹ѤƤޤ
 *      astronote󡢤꤬Ȥޤ
 *        http://b.astronote.jp/log/eid54.html
 * 
 * 
 *        #tagcloud()  ָߤΥڡ̾/XXXפηΥڡФ뻲ȿ
 *                        Ȥơtagcloudɽޤɽ20ˤʤޤ
 *        #tagcloud(tag,8)  tag/XXXפηΥڡФ뻲ȿ򥫥Ȥơ
 *                             tagcloudɽޤɽ8ˤʤޤ
 *
 *
 * @author Yuki SHIDA <shida@in3c.org>
 * @copyright Copyright &copy; in3c.org
 * @license http://opensource.org/licenses/gpl-license.php GNU Public License
 * @version $Revision$
 * 
 */

function plugin_tagcloud_convert()
{

    global $vars, $script;

	list($pettern, $max) = func_get_args();
    if (empty($pettern)) {
        $pettern = $vars["page"];
    }
    if (empty($max)) {
        $max = TAGCLOUD_MAX;
    }

    $cloud = new TagCloud();

    if (!file_exists(CACHE_DIR . 'recent.dat')) {
        die_message(CACHE_DIR . 'recent.dat is not found or not readable.');
    }

    $lines = file(CACHE_DIR . 'recent.dat');
    foreach ($lines as $line) {
        $line = trim($line);
        list($timestamp, $page) = split("\t", $line);
        if (preg_match("@^$pettern/(.*)@", $page, $match)) {
            $tag   = $match[1];
            $count = tagcloud_get_count($pettern, $tag);
            $url   = $script . '?cmd=read&page=' . rawurlencode($page);
            if ($count !== false) {
                $cloud->add($tag, 
                            $url,
                            $count);
            }
        }
    }

    return $cloud->html($max);
}

function tagcloud_get_count($pettern, $tag) {

    $ref_file = CACHE_DIR.encode("$pettern/$tag").'.ref';
    if (!file_exists($ref_file)) {
        return false;
    }

    $count = 0;
    foreach (file($ref_file) as $line) {
        if (preg_match("/^:/", $line)) {
            continue;
        }
        ++$count;
    }
    return $count;
}

?>
