<?php
/*
 * $Id$
 * 
 * License:  GNU General Public License
 *
 * Copyright (c) 2006 in3c.org
 *
 * This software is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 * USA.
 * 
 */

define("PROGRESS_TRACKER_UPDATE_BUTTON", "ĽϿ");
define("PROGRESS_TRACKER_BURN_DOWN_CHART_TABLE_TITLE", "burn down chart table");
define("PROGRESS_TRACKER_TOTAL_MANPOWER_TABLE_TITLE", "total manpower table");
define("PROGRESS_TRACKER_FINISHED_MANPOWER_TABLE_TITLE", "finished manpower table");
define("PROGRESS_TRACKER_UPDATE", "[]");
define("PROGRESS_TRACKER_INSERT", "[ɲ]");
define("PROGRESS_TRACKER_BURN_DOWN_CHART_UPDATE_LOG_TEMPLATE",
       "%sС㡼ѥơ֥: Ĥ깩 %s: %s");
define("PROGRESS_TRACKER_TOTAL_MANPOWER_TABLE_UPDATE_LOG_TEMPLATE",
       "%sơ֥: ׹ %s: %s");
define("PROGRESS_TRACKER_FINISHED_MANPOWER_TABLE_UPDATE_LOG_TEMPLATE",
       "%s1ξòơ֥: ò %s: %s");
define("PROGRESS_TRACKER_THERE_IS_UPDATE", "%s򹹿ޤ ...");
define("PROGRESS_TRACKER_THERE_IS_NO_UPDATE", "ĽѹϸĤޤǤ<br>ɽ %s ǧǤޤ");

require_once(PLUGIN_DIR . 'tracker.inc.php');
require_once(PLUGIN_DIR . 'chart.inc.php');

function plugin_progress_tracker_convert()
{
	global $vars;

    $args = func_get_args();

    $page = $vars['page'];

    switch (count($args)) {
    case 3:
        $args[2] = get_fullname($args[2],$page);
        $page = is_pagename($args[2]) ? $args[2] : $page;
    case 2:
        $config = ($args[1] != '') ? $args[1] : 'default';
	}

    if (empty($args[0])) {
        return "<div>Please set chart page.</div>";
    }

    $params = "plugin=progress_tracker&" . 
              "chart_page=" . rawurlencode($args[0]) . "&" . 
              "config="     . rawurlencode($config) . "&" . 
              "page="       . rawurlencode($page) . "&" . 
           
   "refer="      . rawurlencode($vars['page']);

    return "<script src='" . SKIN_DIR . "prototype.js' type='text/javascript'></script>
            <script src='" . SKIN_DIR . "progress_tracker.js' type='text/javascript'></script>
            <div><input type='button' "
                     . "name='button' "
                     . "value='" . PROGRESS_TRACKER_UPDATE_BUTTON . "' "
                     . "onClick='"
                          . "sendProgressTrackerRequest(\"" . get_script_uri() . "\", " . 
                                                       "\"$params\");' />
            </div>
            <div id='progress_tracker_computing' style='display: none;'>Now Computing ...</div>
            <div id='progress_tracker_result'></div>";

}


function plugin_progress_tracker_action()
{
    global $vars;

 	$config = new Config('plugin/tracker/'.$vars['config']);

	if (!$config->read())
	{
		die("config file '".htmlspecialchars($vars['config'])."' is not exist.");
	}
    
	$config->config_name = $config;

	if (!is_page($config->page.'/list')) {
		die("config file '" .
            make_pagelink($config->page . '/list') . 
            "' not found.");
	}

	$list = &new Progress_Tracker_list($vars['page'],$vars['refer'], $config, 'list');

    if (! $list->parse_chart_page($vars['chart_page'])) {
        die($list->error);
    }

    if ($list->compute() === false) {
        die($list->error);
    }

    if ($list->write_chart_page() === false) {
        die($list->error);
    }

    $list->echo_update_log();
	exit;
}


class Progress_Tracker_list extends Tracker_list {

    var $total_manpower;
    var $total_manpower_per_user;
    var $total_not_finished_manpower;
    var $total_not_finished_manpower_per_user;
    var $finished_manpower;
    var $finished_manpower_per_user;
    var $chart_page;
    var $chart_page_config;
    var $chart_table;
    var $chart_table_updated;
    var $chart_table_update_log;
    var $error;

    var $DEFAULT_BURN_DOWN_CHART_TABLE 
        = array(array('', 'extected', 'actual'),
                array('', 'blue', 'red'));

    var $DEFAULT_TOTAL_MANPOWER_TABLE 
    = array(array('', 'total manpower'));

    var $DEFAULT_FINISHED_MANPOWER_TABLE 
    = array(array('', 'finished manpower'));

    function parse_chart_page($chart_page) {

        if (!isset($this->chart_page_config)) {
            if (! is_page($chart_page)) {
                $this->error = "cannot find chart page: " . mb_convert_encoding($chart_page, 'UTF-8');
                return false;
            }

            check_readable($chart_page);
            check_editable($chart_page);

            $this->chart_page_config = new ChartTable($chart_page);

            if (!$this->chart_page_config->read()) {
                $this->error = "config file '" .
                    htmlspecialchars(mb_convert_encoding($chart_page, 'UTF-8')) .
                    "' not found.";
                return false;
            }
            $this->chart_page = $chart_page;
        }

        return true;
    }

    function compute() {

        if ($this->compute_total_manpower() === false) {
            return false;
        }

        if ($this->compute_total_not_finished_manpower() === false) {
            return false;
        }

        if ($this->update_chart_table(PROGRESS_TRACKER_TOTAL_MANPOWER_TABLE_TITLE,
                                      $this->DEFAULT_TOTAL_MANPOWER_TABLE,
                                      2,
                                      2,
                                      $this->total_manpower,
                                      PROGRESS_TRACKER_TOTAL_MANPOWER_TABLE_UPDATE_LOG_TEMPLATE) 
            === false) {
            return false;
        }

        if ($this->update_chart_table(PROGRESS_TRACKER_BURN_DOWN_CHART_TABLE_TITLE,
                                      $this->DEFAULT_BURN_DOWN_CHART_TABLE,
                                      3,
                                      3,
                                      $this->total_not_finished_manpower,
                                      PROGRESS_TRACKER_BURN_DOWN_CHART_UPDATE_LOG_TEMPLATE) 
            === false) {
            return false;
        }
        
        if ($this->compute_finished_manpower() === false) {
            return false;
        }

        if ($this->update_chart_table(PROGRESS_TRACKER_FINISHED_MANPOWER_TABLE_TITLE,
                                      $this->DEFAULT_FINISHED_MANPOWER_TABLE,
                                      2,
                                      2,
                                      $this->finished_manpower,
                                      PROGRESS_TRACKER_FINISHED_MANPOWER_TABLE_UPDATE_LOG_TEMPLATE)
            === false) {
            return false;
        }
    }

    function compute_total_manpower() {
        
        if (! isset($this->fields['manpower'])) {
            $this->error = 'Please make fields "manpower"';
            return false;
        }

        foreach ($this->rows as $row) {
            $this->total_manpower += $row['manpower'];
        }

        return true;
    }

    function compute_total_not_finished_manpower() {
        
        if (! isset($this->fields['manpower'])) {
            $this->error = 'Please make fields "manpower"';
            return false;
        }
        if (! isset($this->fields['state'])) {
            $this->error = 'Please make fields "state"';
            return false;
        }
        if (! isset($this->config->objs['progress_rate'])) {
            $this->error = 'Please make fields "progress_rate"';
            return false;
        }

        $total_finished_manpower = 0;
        foreach ($this->rows as $row) {
            $finished_manpower = 
                $this->compute_row_finished_manpower($row['manpower'],
                                                     $row['state'],
                                                     $this->config->objs['progress_rate']->values);
            if ($finished_manpower === false) {
                return false;
            }
            $total_finished_manpower += $finished_manpower;
                
        }

        $this->total_not_finished_manpower = 
            $this->total_manpower - 
            $total_finished_manpower;

        return true;
    }

    // (Υȡ빩 - ΥȡĤ깩)
    // - (Υȡ빩 - ΥȡĤ깩)
    function compute_finished_manpower() {

        $today = date('Y/m/d');

        $previous_total_manpower = $this->total_manpower;
        reset($this->chart_table[PROGRESS_TRACKER_TOTAL_MANPOWER_TABLE_TITLE]);
        foreach ($this->chart_table[PROGRESS_TRACKER_TOTAL_MANPOWER_TABLE_TITLE]
                 as $row) {
            if ($row[0] == $today) {
                break;
            }
            $previous_total_manpower = $row[1];
        }

        $previous_total_not_finished_manpower = $this->total_not_finished_manpower;
        reset($this->chart_table[PROGRESS_TRACKER_BURN_DOWN_CHART_TABLE_TITLE]);
        foreach ($this->chart_table[PROGRESS_TRACKER_BURN_DOWN_CHART_TABLE_TITLE]
                 as $row) {
            if ($row[0] == $today) {
                break;
            }
            $previous_total_not_finished_manpower = $row[2];
        }

        $this->finished_manpower = 
            ($this->total_manpower - $this->total_not_finished_manpower) - 
            ($previous_total_manpower - $previous_total_not_finished_manpower);

        return true;
    }

    function compute_row_finished_manpower($manpower, $state, $progress_rate_array) {

        foreach ($progress_rate_array as $progress_rate) {
            if ($progress_rate[0] == $state) {
                return $manpower * $progress_rate[1] / 100;
            }
        }
        $this->error = "illegal state: $state";

        return false;
    }

    function update_chart_table($chart_title,
                                $default_chart_table,
                                $column_num,
                                $compaire_column_num,
                                $new_value,
                                $log_template) {

        $this->chart_table[$chart_title] =
            $this->get_chart_table($chart_title);
        if ($this->chart_table[$chart_title] === false) {
            return false;
        }
        if (! (isset($this->chart_table[$chart_title]) &&
               is_array($this->chart_table[$chart_title]))) {
            $this->chart_table[$chart_title] = $default_chart_table;
        }

        $today = date('Y/m/d');

        for ($i = 0;
             $i < sizeof($this->chart_table[$chart_title]);
             ++$i) {
            if ($this->chart_table[$chart_title][$i][0] == $today) {
                if (strval($this->chart_table[$chart_title][$i][$compaire_column_num - 1]) != 
                    strval($new_value)) {
                    $this->chart_table_updated[$chart_title] = true;
                    $old_value = $this->chart_table[$chart_title][$i][$compaire_column_num - 1];
                    $this->chart_table[$chart_title][$i][$compaire_column_num - 1] = 
                        $new_value;
                    $this->chart_table_update_log[$chart_title] =
                        sprintf($log_template,
                                PROGRESS_TRACKER_UPDATE,
                                "$old_value -> $new_value",
                                $today);
                }
                return true;
            }
        }

        // todayĤʤäϡˤĤ
        $new_row = array();

        for ($i = 0; $i < $column_num;++$i) {
            if ($i == 0) {
                $new_row[] = $today;
            }
            elseif ($i == ($compaire_column_num - 1)) {
                $new_row[] = $new_value;
            }
            else {
                $new_row[] = '';
            }
        }
        $this->chart_table[$chart_title][] = $new_row;

        $this->chart_table_update_log[$chart_title] =
            sprintf($log_template,
                    PROGRESS_TRACKER_INSERT,
                    $new_value,
                    $today);
        $this->chart_table_updated[$chart_title] = true;

        return true;
    }

    function get_chart_table($table_title) {

        return $this->chart_page_config->objs[$table_title]->values;
    }

    function write_chart_page() {

        $str = "";
        $updated = false;

        foreach (array(PROGRESS_TRACKER_BURN_DOWN_CHART_TABLE_TITLE,
                       PROGRESS_TRACKER_TOTAL_MANPOWER_TABLE_TITLE,
                       PROGRESS_TRACKER_FINISHED_MANPOWER_TABLE_TITLE)
                 as $table_title) {
            $str .= $this->get_chart_table_string($table_title,
                                                  $this->chart_table[$table_title]);
            if ($this->chart_table_updated[$table_title] === true) {
                $updated = true;
            }
        }
        if ($updated === true) {
            return page_write($this->chart_page, $str);
        }
    }

    function echo_update_log() {

        foreach (array(PROGRESS_TRACKER_BURN_DOWN_CHART_TABLE_TITLE,
                       PROGRESS_TRACKER_TOTAL_MANPOWER_TABLE_TITLE,
                       PROGRESS_TRACKER_FINISHED_MANPOWER_TABLE_TITLE)
                 as $table_title) {
            if (!empty($this->chart_table_update_log[$table_title])) {
                $buf .= "<li>" . $this->chart_table_update_log[$table_title] . "</li>";
            }
        }

        if (!empty($buf)) {
            $buf = sprintf(PROGRESS_TRACKER_THERE_IS_UPDATE,
                           "<a href='" . get_script_uri() . '?' .
                           rawurlencode($this->chart_page) . "'>" . 
                           $this->chart_page . "</a>") . 
                   "<ul>$buf</ul>";
        }
        else {
            $buf = sprintf(PROGRESS_TRACKER_THERE_IS_NO_UPDATE,
                           "<a href='" . get_script_uri() . '?' .
                           rawurlencode($this->chart_page) . "'>" . 
                           $this->chart_page . "</a>");
        }

        echo "<div id='progress_tracker_result_log'>" . 
            mb_convert_encoding($buf, 'UTF-8') . "</div>";

        return true;
    }

    function get_chart_table_string($table_title,
                                    $chart_table) {

        $str = "*$table_title\n";

        for ($i = 0;$i < sizeof($chart_table);++$i) {
            $line = "|";
            for ($j = 0;$j < sizeof($chart_table[$i]);++$j) {
                $line .= $chart_table[$i][$j] . "|";
            }
            $str .= $line . "\n"; 
        }

        return $str;
    }
}

?>
