<?php
/*
 * $Id$
 * 
 * License:  GNU General Public License
 *
 * Copyright (c) 2006 in3c.org
 *
 * This software is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 * USA.
 * 
 */

include_once LIB_DIR . "seymour/feed_reader.php";

define("GOOGEL_CALENDAR_VIEWER_STYLE_SHEET","
<style tyle='text/css'>
.google_calendar_viewer {
  margin: 20px;
  padding: 15px;
}
.google_calendar_viewer_title {
   font-weight: bold;
   font-size : 15px;
   border-bottom: gray solid thin;
   margin-bottom: 10px;   
}
.google_calendar_viewer_subtitle {
   border-bottom: gray solid thin;
   margin-bottom: 10px;   
}
.google_calendar_viewer_term_text {
   margin: 10px 0px 10px 0px;
}
.google_calendar_viewer_entries {
   margin-left:  20px;
}
.google_calendar_viewer_entry {
}
.google_calendar_viewer_entry_published {
  float: left;
  width: 100px;
}
.google_calendar_viewer_entry_title {
  width: 350px;
}
.google_calendar_link {
  margin: 10px;
  text-align: right;
  border: none;
}
</style>
");
define("GOOGLE_CALENDAR_VIEWER_TEMPLATE", "<div class='google_calendar_viewer'>
%s%s%s
<div class='google_calendar_link'><a href='http://www.google.com/calendar/'>&gt;&gt; Google Calendar</a></div>
</div>");
define("GOOGLE_CALENDAR_VIEWER_TITLE_TEMPLATE", 
       "<div class='google_calendar_viewer_title'>̾: %s</div>");
define("GOOGLE_CALENDAR_VIEWER_SUBTITLE_TEMPLATE", 
       "<div class='google_calendar_viewer_subtitle'>%s</div>");
define("GOOGLE_CALENDAR_VIEWER_ENTIRIES_TEMPLATE", 
       "<ul class='google_calendar_viewer_entries'>%s</ul>");
define("GOOGLE_CALENDAR_VIEWER_ENTIRY_TEMPLATE", 
       "<li class='google_calendar_viewer_entry'>%s%s</li>");
define("GOOGLE_CALENDAR_VIEWER_ENTIRY_PUBLISHED_TEMPLATE", 
       "<div class='google_calendar_viewer_entry_published'>%s</div>");
define("GOOGLE_CALENDAR_VIEWER_ENTIRY_PUBLISHED_FORMAT", 
       "Y/m/d");
define("GOOGLE_CALENDAR_VIEWER_ENTIRY_TITLE_TEMPLATE", 
       "<div class='google_calendar_viewer_entry_title'>%s</div>");
define("GOOGLE_CALENDAR_VIEWER_ENTIRY_CONTENT_TEMPLATE", 
       "<div class='google_calendar_viewer_entry_content'>%s</div>");
define("GOOGLE_CALENDAR_VIEWER_TERM_TEXT",
       "<div class='google_calendar_viewer_term_text'>%sޤǤΥ塼ɽޤ</div>");

/**
 * 
 * 
 *     #google_calendar_viewer(URI, [TERM])
 * 
 * 
 *     ֥åץ饰
 *
 * 
 *     Google CalendarCalendar feedURIꤷơ
 *     ΥΥ٥Ȥɽޤ
 *
 * 
 *     #google_calendar_viewer(http://www.google.com/calendar/feeds/g23fopdl4gvmqisc6r7gqj98cuoagioi%40import.calendar.google.com/public/basic, 30) -> 30ޤǤΡJapanese HolidaysפΥ٥Ȥɽޤ
 *
 * @author Yuki SHIDA <shida@in3c.org>
 * @copyright Copyright &copy; in3c.org
 * @license http://opensource.org/licenses/gpl-license.php GNU Public License
 * @version $Revision$
 */

function plugin_google_calendar_viewer_convert() {

    list($feed_url, $term) = func_get_args();

    $feedReader = new feedReader();
    $feed = $feedReader->getFeed($feed_url);
    if ($feedReader->error) {
        die_message("google_calendar_viewer error: " . 
                    $feedReader->errorCode);
    }
    
    $title_str    = sprintf(GOOGLE_CALENDAR_VIEWER_TITLE_TEMPLATE,
                            '<a href="' . $feed->links[0]->href . '">' . 
                            mb_convert_encoding($feed->getTitle(),
                                                "EUC-JP",
                                                "UTF-8") . 
                            '</a>');
    $subtitle_str = sprintf(GOOGLE_CALENDAR_VIEWER_SUBTITLE_TEMPLATE,
                            mb_convert_encoding($feed->getSubtitle(),
                                                "EUC-JP",
                                                "UTF-8"));
    $entries      = $feed->getEntries();

    foreach ($entries as $entry) {
        if (!empty($term) &&
            $entry->getPublished() >= mktime(0, 0, 0) + ($term + 1) * 24 * 60 * 60) {
            continue;
        }
        $entry_published_str = sprintf(GOOGLE_CALENDAR_VIEWER_ENTIRY_PUBLISHED_TEMPLATE,
                                       date(GOOGLE_CALENDAR_VIEWER_ENTIRY_PUBLISHED_FORMAT,
                                            $entry->getPublished()));
        $entry_title_str     = sprintf(GOOGLE_CALENDAR_VIEWER_ENTIRY_TITLE_TEMPLATE,
                                       '<a href="' . $entry->links[0]->href . '">' .
                                       mb_convert_encoding($entry->getTitle(),
                                                           "EUC-JP",
                                                           "UTF-8").
                                       '</a>');
        $entry_content_str   = sprintf(GOOGLE_CALENDAR_VIEWER_ENTIRY_CONTENT_TEMPLATE,
                                       mb_convert_encoding($entry->getContent(),
                                                           "EUC-JP",
                                                           "UTF-("));
        $entry_str          .= sprintf(GOOGLE_CALENDAR_VIEWER_ENTIRY_TEMPLATE,
                                       $entry_published_str, $entry_title_str, $entry_content_str);
    }
  
    if (!empty($term)) {
        $entries_str = sprintf(GOOGLE_CALENDAR_VIEWER_TERM_TEXT, $term);
    }
    $entries_str .= sprintf(GOOGLE_CALENDAR_VIEWER_ENTIRIES_TEMPLATE,
                            $entry_str);
    return  GOOGEL_CALENDAR_VIEWER_STYLE_SHEET . 
            sprintf(GOOGLE_CALENDAR_VIEWER_TEMPLATE,
                    $title_str,
                    $subtitle_str,
                    $entries_str);
    
}
?>