<?php
/*
 * $Id$
 * 
 * License:  GNU General Public License
 *
 * Copyright (c) 2005 in3c.org
 *
 * This software is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 * USA.
 * 
 */

// ̾ά̾
define("CHART_DEFAULT_CONFIG_NAME","default");

// ڡɤ߽ФФ̾
define("CHART_CONFIG_TITLE","chart_setting");

// 顼ɽ˻Ѥǥեȥե
define("CHART_ERROR_FONT", LIB_DIR . "ykcee/VERDANA.TTF");

// 顼ʸ
define("CHART_PARAMETER_ERROR", "<p>parameter error</p>");

// 顼ʸ
define("CHART_CANNOT_READ_CONFIG", "cannot read config");

// 顼ʸ
define("CHART_CANNOT_READ_TABLE", "cannot read table");

/**
 * 
 * 
 *     #chart(title,[page],[̾])
 * 
 *  
 *     ֥åץ饰
 *
 * 
 *      ɽɤ߹ǥդɽޤ
 *      ɽϥڡ̾ȸФ̾ꤵ졢ŪConfig饹
 *      Ѥɤ߹ޤޤ
 *      դykcee(http://ykcee.sourceforge.net/)Ѥޤ
 *      κݤοʤɤϡ:config/plugin/chart/̾ΥեѤ
 *      ꤷޤ
 * 
 * 
 *      #bliki(my_chart)           ߤΥڡˤ٥1ߤmy_chartפ˽񤫤줿ɽ
 *                                   :config/plugin/chart/default˴Ť褷ޤ
 *      #bliki(my_chart,foo)       ڡfooˤ٥1ߤmy_chartפ˽񤫤줿ɽ
 *                                   :config/plugin/chart/default˴Ť褷ޤ
 *      #bliki(my_chart,foo,bar)   ڡfooˤ٥1ߤmy_chartפ˽񤫤줿ɽ
 *                                   :config/plugin/chart/bar˴Ť褷ޤ
 *      #bliki(my_chart,,bar)      ߤΥڡˤ٥1ߤmy_chartפ˽񤫤줿ɽ
 *                                   :config/plugin/chart/bar˴Ť褷ޤ
 *
 *
 * @author Yuki SHIDA <shida@in3c.org>
 * @copyright Copyright &copy; in3c.org
 * @license http://opensource.org/licenses/gpl-license.php GNU Public License
 * @version $Revision$
 * 
 */


function plugin_chart_convert() {

    global $script;

    $args = chart_process_args(func_get_args());
    if (! $args) {
        return CHART_PARAMETER_ERROR;
    }

    foreach ($args as $key => $val) {
        $query_string .= "$key=" . urlencode($val) . "&";
    }

    return "<img src='$script?plugin=chart&$query_string' />";
}

function plugin_chart_action() {

    global $vars;

    $params = read_config($vars['config_name']);
    if (! $params) {
        draw_error(CHART_CANNOT_READ_CONFIG);
        exit();
    }

    $table = new ChartTable($vars['page']);
	if (! $table->read()) {
        draw_error(CHART_CANNOT_READ_TABLE);
        exit();
	}
    $array = $table->get($vars['title']);

    $graph = init_graph($params);
    $graph->SetChartTitle($vars['title']);
    $row = array_shift($array);
	$graph->SetLegend(array_splice($row, 1));
    $row = array_shift($array);
    $graph->SetBarColor(array_splice($row, 1));
	$graph->SetDataValues($array);

    $graph->DrawGraph();

    exit();
}

function chart_process_args($args) {

    global $vars;

    if (empty($args[0])) {
        return false;
    }

    if (! empty($args[1])) {
        $page = $args[1];
    }
    else {
        $page = $vars["page"];
    }
    if (! empty($args[2])) {
        $config_name = $args[2];
    }
    else {
        $config_name = CHART_DEFAULT_CONFIG_NAME;
    }

    return array("title"       => $args[0],
                 "page"        => $page,
                 "config_name" => $config_name);
}

function read_config($config_name) {

    $config = new Config("plugin/chart/$config_name");

	if (!$config->read()) {
        return false;
	}
    
    foreach ($config->get(CHART_CONFIG_TITLE) as $row) {
        list($key, $value) = $row;
        $params[$key] = $value;
    }

    return $params;
}

function init_graph($params) {

    include_once LIB_DIR . "/ykcee/ykcee.php";
	$graph = new ykcee;

    $graph->SetImageSize($params['ImageWidthSize'], $params['ImageHeightSize']);
	$graph->SetTitleFont(LIB_DIR . "/ykcee/" . $params['TitleFont']);
	$graph->SetFont(LIB_DIR . "/ykcee/" . $params['Font']);
	$graph->SetFileFormat($params['FileFormat']);
    $graph->SetBackgroundColor($params['BackgroundColor']);
    $graph->SetChartBackgroundColor($params['ChartBackgroundColor']);
	$graph->SetMaxStringSize($params['MaxStringSize']);
    $graph->SetChartBorderColor($params['ChartBorderColor']);
	$graph->SetChartType($params['ChartType']);
    $graph->SetChartTitleSize($params['ChartTitleSize']);
    $graph->SetChartTitleColor($params['ChartTitleColor']);
    $graph->SetFontColor($params['FontColor']);
    $graph->SetBarBorderColor(array("black"));
    $graph->SetLegendPosition($params['LegendPosition']);
    $graph->SetTitleAxisX($params['TitleAxisX']);
    $graph->SetTitleAxisY($params['TitleAxisY']);
	$graph->SetAxisFontSize($params['AxisFontSize']);
    $graph->SetAxisColor($params['AxisColor']);
    $graph->SetAxisTitleSize($params['AxisTitleSize']);
    $graph->SetTickLength($params['TickLength']);
    $graph->SetTickInterval($params['TickInterval']);
    $graph->SetGridX($params['GridX']);
    $graph->SetGridY($params['GridY']);
    $graph->SetGridColor($params['GridColor']);
	$graph->SetLineThickness($params['LineThickness']);
	$graph->SetPointSize($params['PointSize']); //es werden dringend gerade Zahlen empfohlen
	$graph->SetPointShape($params['PointShape']);
	$graph->SetShading($params['Shading']);
	$graph->SetNoData($params['NoData']);

    return $graph;
}

function draw_error($error_message) {

    header ("Content-type: image/png");

    $im = imagecreate(300,200);
    $white = imagecolorallocate($im, 255,255,255);
    $black = imagecolorallocate($im, 0,0,0);
  
    // Replace path by your own font path
    imagettftext($im, 12, 0, 20, 180, $black, CHART_ERROR_FONT,
                 $error_message);
    imagepng($im);
    imagedestroy($im);

    return true;
}

class ChartTable extends Config {

    function ChartTable($name) {
        $this->name = $name;
        $this->page = $name;
    }
}

?>